<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductCategoryTreeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this['id'],
            'name' => $this['name'],
            'parent_id' => $this['parent_id'],
            'is_leaf' => $this['is_leaf'],
            'subcategories_count' => $this['subcategories_count'],
            'children' => self::collection($this['children']),
        ];
    }
}
