<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductBundleComponentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'quantity' => $this->quantity,
            'componentProduct' => $this->whenLoaded('childProduct'),
            'bundleProduct' => $this->whenLoaded('parentProduct'),
        ];
    }
}
