<?php

namespace App\Http\Resources;

use App\Models\ProductListing;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @mixin ProductListing
 */
class PreviewSyncInventoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'product' => $this->product->only(['id', 'name', 'sku']),
            'listing_id' => $this->sales_channel_listing_id,
            'listing_sku' => $this->listing_sku,
            'quantity' => $this->quantity,
            'listing_url' => $this->document ? $this->document->getListingUrl() : null,
        ];
    }
}
