<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\PaymentType;
use Illuminate\Http\Request;

/** @mixin PaymentType */
class PaymentTypeResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->inclusive('name', $this->name),
            'accounting_integration_id' => $this->accounting_integration_id,
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
        ];
    }
}
