<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\PaymentMethodMappingSalesChannelToSku;
use Illuminate\Http\Request;

/**
 * @mixin PaymentMethodMappingSalesChannelToSku
 */
class PaymentMethodMappingSalesChannelResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'sales_channel_id' => $this->sales_channel_id,
            'sales_channel_method' => $this->sales_channel_method,
            'shipping_method_id' => $this->payment_type_id,
            'shipping_method_name' => $this->paymentType?->name,
        ];
    }
}
