<?php

namespace App\Http\Resources;

use App\Helpers;
use App\Models\SupplierProduct;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class POBuilderSupplierProductResource.
 *
 * @mixin SupplierProduct
 */
class POBuilderSupplierProductResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'product_id' => $this->product_id,
            'supplier_id' => $this->supplier_id,
            'supplier_sku' => $this->supplier_sku,
            'leadtime' => $this->leadtime,
            'minimum_order_quantity' => $this->minimum_order_quantity,
            'is_default' => $this->is_default,
            'product' => $this->product->only(['id', 'sku', 'name', 'barcode', 'image']),
            'supplier_stock' => $this->product->suppliersInventory()->where('supplier_id', $this->supplier_id)->first() ?? 0,
            'pricing' => SupplierProductPricingResource::collection($this->whenLoaded('supplierPricingTiers')),
            'price' => Helpers::getDecimalAttribute($this->supplierPricingTiers->firstWhere('id', $request->input('pricing_tier_id'))->pivot->price ?? 0),
        ];
    }
}
