<?php

namespace App\Http\Resources\Magento;

use App\DataTable\DataTableResource;
use App\Models\Magento\Store;
use Illuminate\Http\Request;

/**
 * Class StoreResource.
 *
 * @mixin Store
 */
class StoreResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'integrationInstance' => $this->integrationInstance?->name,
            'magentoStore' => $this->magentoStore?->name,
            'magento_store_id' => $this->magentoStore?->id,
            'skuStore' => $this->skuStore?->name,
            'sku_store_id' => $this->skuStore?->id,
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
