<?php

namespace App\Http\Resources\Magento;

use App\DataTable\DataTableResource;
use App\Models\Magento\Order;
use Illuminate\Http\Request;

/**
 * Class OrderResource.
 *
 * @mixin Order
 */
class OrderResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'increment_id' => $this->inclusive('increment_id', $this->increment_id),
            'state' => $this->inclusive('state', $this->json_object['state']),
            'customer_firstname' => $this->inclusive('customer_firstname', $this->json_object['customer_firstname'] ?? null),
            'customer_lastname' => $this->inclusive('customer_lastname', $this->json_object['customer_lastname'] ?? null),
            'customer_email' => $this->inclusive('customer_email', $this->json_object['customer_email']),
            'grand_total' => $this->inclusive('grand_total', $this->json_object['grand_total']),
            'created_at' => $this->inclusive('created_at', $this->magento_created_at),
            'updated_at' => $this->inclusive('updated_at', $this->magento_updated_at),
            'archived_at' => $this->archived_at,
        ];
    }
}
