<?php

namespace App\Http\Resources;

use App\Models\InventoryForecast;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * @mixin InventoryForecast
 */
class InventoryForecastResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'forecast_date' => $this->forecast_date,
            'days_of_sales_history' => $this->days_of_sales_history,
            'max_projection_days' => $this->max_projection_days,
            'items' => $this->whenLoaded('inventoryForecastItems', function () {
                return InventoryForecastItemResource::collection($this->inventoryForecastItems);
            }),
            'supplier' => $this->whenLoaded('supplier', function () {
                return [
                    'id' => $this->supplier_id,
                    'name' => $this->supplier->name,
                    'leadtime' => $this->supplier->leadtime,
                    'default_pricing_tier' =>  $this->supplier->defaultPricingTier ? [
                        'id' => $this->supplier->defaultPricingTier->id,
                        'name' => $this->supplier->defaultPricingTier->name,
                        'currency_code' => $this->supplier->defaultPricingTier->currency_code,
                    ] : []
                ];
            }),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
