<?php

namespace App\Http\Resources;

use App\Models\InventoryMovement;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InventoryAssemblyLineResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'quantity' => (int) $this->quantity,
            'id' => $this->product->id,
            'name' => $this->product->name,
            'sku' => $this->product->sku,
            'barcode' => $this->product->barcode,
            'product_type' => $this->product_type,
            'unit_cost' => $this->unit_cost,
            'available_stock' => ['available' => $this->product->inventoryMovements
                ->where('warehouse_id', $this->inventoryAssembly->warehouse_id)
                ->where('inventory_status', InventoryMovement::INVENTORY_STATUS_ACTIVE)
                ->sum('quantity') ?? 0,
            ],
        ];
    }
}
