<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\SalesOrderFulfillmentLine;
use Illuminate\Http\Request;

/**
 * @mixin SalesOrderFulfillmentLine
 */
class FulfillmentLineResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'fulfillment_line_id' => $this->id, // for exporting
            'item_quantity' => $this->inclusive('item_quantity', $this->quantity),
            'item_sku' => $this->inclusive('item_sku', $this->whenLoaded('salesOrderLine', function () {
                return [
                    'id' => $this->salesOrderLine->product_id,
                    'sku' => $this->salesOrderLine->product->sku ?? null,
                ];
            })),
            'item_price' => $this->inclusive('item_price', $this->whenLoaded('salesOrderLine', function () {
                return $this->salesOrderLine->amount;
            })),
            'item_name' => $this->inclusive('item_name', $this->whenLoaded('salesOrderLine', function () {
                return $this->salesOrderLine->description;
            })),
            'item_nominal_code' => $this->inclusive('item_nominal_code', $this->whenLoaded('salesOrderLine', function () {
                return $this->salesOrderLine->nominalCode->name ?? null;
            })),
        ];
    }
}
