<?php

namespace App\Http\Resources;

use App\DataTable\NewDataTableResource;
use App\Models\FinancialAlert;

/**
 * @mixin FinancialAlert
 */
class FinancialAlertResource extends NewDataTableResource
{
    public function getCustomColumns(): array
    {
        $salesOrderLineFinancial = $this->salesOrderLineFinancial;
        $salesOrderLine = $salesOrderLineFinancial->salesOrderLine;
        $salesOrder = $salesOrderLine->salesOrder;
        $product = $salesOrderLine->product;
        $allocatedDetails = $salesOrderLine->financialAllocatables->map(function ($allocatable) {
            return [
                "description" => $allocatable->description,
                "amount" => $allocatable->pivot->amount
            ];
        });
        return [
            'salesOrder' => $salesOrder->sales_order_number,
            'salesOrderId' => $salesOrder->id,
            'sku' => $product?->sku,
            'product_id' => $product?->id,
            'total_revenue' => round($salesOrderLineFinancial->total_revenue, 2),
            'cogs' => round($salesOrderLineFinancial->cogs, 2),
            'cogs_returned' => round($salesOrderLineFinancial->cogs_returned, 2),
            'cost_allocated' => round($salesOrderLineFinancial->cost_allocated, 2),
            'allocated_details' => $allocatedDetails,
            'total_cost' => round($salesOrderLineFinancial->total_cost, 2),
            'profit' => round($salesOrderLineFinancial->profit, 2),
            'profit_margin' => round($salesOrderLineFinancial->profit_margin * 100, 2),
            'classification' => $this->financialAlertClassification?->name,
            'classification_id' => $this->financial_alert_classification_id,
            'archived_by_user' => $this->archivedByUser?->name,
            'archived_at' => $this->archived_at,
        ];
    }
}
