<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\FifoLayer;
use App\Models\Warehouse;
use Illuminate\Http\Request;

/**
 * Class FifoLayerResource.
 *
 * @mixin FifoLayer
 */
class FifoLayerResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'product_id' => $this->product_id,
            'fifo_layer_date' => $this->inclusive('fifo_layer_date', $this->fifo_layer_date),
            'sku' => $this->inclusive('sku', $this->product->sku),
            'product_name' => $this->inclusive('product_name', $this->product->name),
            'product_barcode' => $this->product->barcode,
            'original_quantity' => $this->inclusive('original_quantity', $this->original_quantity),
            'fulfilled_quantity' => $this->inclusive('original_quantity', $this->fulfilled_quantity),
            'total_cost' => $this->inclusive('total_cost', $this->total_cost),
            'origin' => $this->inclusive('origin', [
                'link_type' => $this->link_type,
                'link_id' => $this->link_id,
                'name' => $this->link_name,
                'parent_link_id' => $this->parent_link_id,
                'reference' => $this->link_reference,
            ]),
            'warehouse' => $this->whenLoaded('warehouse', function () {
                return [
                    'id' => $this->warehouse_id,
                    'name' => $this->warehouse->name,
                ];
            }),
            'is_fba' => $this->warehouse->type == Warehouse::TYPE_AMAZON_FBA,
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
        ];
    }
}
