<?php

namespace App\Http\Resources;

use App\Models\Product;
use App\Models\ProductListing;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Modules\Amazon\Enums\Entities\AmazonProductFulfillmentChannelEnum;

/**
 * Class ProductInventoryDetailsResource.
 *
 *
 * @mixin Product
 */
class FBAProductInventoryDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return $this->productListings()->whereHas('amazonListing', function ($builder) {
            $builder->where('fulfillment_channel', AmazonProductFulfillmentChannelEnum::AMAZON_NA);
        })->get()->map(function (ProductListing $productListing) {
            return [
                'product_listing_id' => $productListing->id,
                'seller_sku' => $productListing->listing_sku,
                'asin' => $productListing->document->asin1 ?? null,
                'available' => $productListing->fbaRealTimeInventory->available_quantity ?? 0,
                'reserved' => $productListing->fbaRealTimeInventory->reserved_quantity ?? 0,
                'in_transit' => $productListing->fbaRealTimeInventory->in_transit ?? 0,
                'total' => $productListing->fbaRealTimeInventory->total_quantity ?? 0,
                'inbound' => $productListing->fbaRealTimeInventory->inbound_quantity ?? 0,
            ];
        })->toArray();
    }
}
