<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CustomerAddressesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'zip' => $this->zip,
            'address1' => $this->address1,
            'addresses' => $this->all_addresses,
            //      'default_shipping_address'              => $this->shippingAddress,
            //      'default_billing_address'               => $this->billingAddress,
            //      'other_addresses'                       => $this->addresses->map( function ( Address $address ) { return collect( $address )->except( 'pivot' ); } ),
            'sales_channel_origin' => $this->whenLoaded('salesChannelOrigin', function () {
                return $this->salesChannelOrigin->only('id', 'name');
            }),
            'default_pricing_tier' => $this->whenLoaded('productPricingTier', function () {
                return $this->productPricingTier->only('id', 'name');
            }),
            'default_store' => $this->whenLoaded('store', function () {
                return $this->store->only('id', 'name');
            }),
            'default_shipping_method_domestic' => $this->whenLoaded('shippingMethodDomestic', function () {
                return $this->shippingMethodDomestic->only('id', 'name');
            }),
            'default_shipping_method_international' => $this->whenLoaded('shippingMethodInternational', function () {
                return $this->shippingMethodInternational->only('id', 'name');
            }),
            'default_warehouse' => $this->whenLoaded('warehouse', function () {
                return $this->warehouse->only('id', 'name');
            }),
        ];
    }
}
