<?php

namespace App\Http\Resources;

use App\Models\BackorderQueueRelease;
use App\Models\InventoryMovement;
use App\Models\PurchaseOrderShipmentReceiptLine;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class BackorderQueueReleaseResource.
 *
 * @mixin BackorderQueueRelease
 */
class BackorderQueueReleaseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'link_type' => $this->link_type,
            'link_id' => $this->link_id,
            'parent_link_id' => $this->parent_link_id,
            'reference' => $this->reference,
            $this->mergeWhen($this->link instanceof PurchaseOrderShipmentReceiptLine, function () {
                /** @var PurchaseOrderShipmentReceiptLine $receiptLine */
                $receiptLine = $this->link;

                $orderLine = $receiptLine->purchaseOrderShipmentLine->purchaseOrderLine;

                return [
                    'purchase_order_line_id' => $orderLine->id,
                    'purchase_order_id' => $orderLine->purchaseOrder->id,
                    'purchase_order_number' => $orderLine->purchaseOrder->purchase_order_number,
                    'eta' => $orderLine->purchaseOrder->estimated_delivery_date,
                    'received_at' => $orderLine->purchaseOrder->fully_received_at ?? $receiptLine->purchaseOrderShipmentReceipt->received_at,
                ];
            }),
            'sales_order' => [
                'sales_order_line_id' => $this->backorderQueue->sales_order_line_id,
                'sales_order_id' => $this->backorderQueue->salesOrderLine->sales_order_id,
                'sales_order_number' => $this->backorderQueue->salesOrderLine->salesOrder->sales_order_number,
            ],
            'backorder_queue' => [
                'id' => $this->backorder_queue_id,
                'priority' => $this->backorderQueue->priority,
                'backordered_quantity' => $this->backorderQueue->backordered_quantity,
                'released_quantity' => $this->backorderQueue->released_quantity,
                'covered_quantity' => $this->backorderQueue->backorderQueueCoverages->sum('unreleased_quantity'),
            ],
            'released_quantity' => $this->released_quantity,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
