<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class BackorderLayerResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        $salesOrderLine = $this->salesOrderLines->first();

        return [
            'id' => $this->id,
            'sku' => $this->whenLoaded('product', function () {
                return $this->product->sku;
            }),
            'product_name' => $this->whenLoaded('product', function () {
                return $this->product->name;
            }),
            'backorder_quantity' => $this->inclusive('backorder_quantity', $this->quantity_backordered),
            'released_quantity' => $this->inclusive('released_quantity', $this->quantity_released),
            'sales_order_number' => $this->whenLoaded('salesOrderLines', function () use ($salesOrderLine) {
                if (! $salesOrderLine) {
                    return [];
                }

                return [
                    'sales_order_line_id' => $salesOrderLine->id,
                    'sales_order_id' => $salesOrderLine->salesOrder->id,
                    'sales_order_number' => $salesOrderLine->salesOrder->sales_order_number,
                ];
            }),
            'sales_order_date' => $this->whenLoaded('salesOrderLines', function () use ($salesOrderLine) {
                if (! $salesOrderLine) {
                    return null;
                }

                return $salesOrderLine->salesOrder->order_date;
            }),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
        ];
    }
}
