<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\Attribute;
use Illuminate\Http\Request;

/**
 * Class AttributeResource.
 *
 * @mixin Attribute
 */
class AttributeResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->inclusive('name', $this->name),
            'id' => $this->id,
            'attribute_group' => $this->inclusive('attribute_group', $this->whenLoaded('attributeGroup', function () {
                return [
                    'id' => $this->attributeGroup->id,
                    'name' => $this->attributeGroup->name,
                ];
            })),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
            'type' => $this->inclusive('type', $this->type),
            'display_options' => $this->inclusive('display_options', $this->display),
            'validation' => $this->inclusive('validation', $this->validation),
            'available_for_templates' => $this->inclusive('available_for_templates', $this->available_for_templates),
            'option_values' => $this->inclusive('option_values', $this->whenLoaded('values', function () {
                return $this->values->map(function ($attributeValue) {
                    return $attributeValue->only('value', 'sort_order');
                });
            })),
            'attribute_group_id' => $this->attribute_group_id,
            'notes' => $this->notes,
        ];
    }
}
