<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AttributeInAttributeGroupResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'type' => $this->type,
            'sort_order' => $this->sort_order,
            'attribute_id' => $this->id, // Keeping this property for backward compatibility.
            'display_options' => $this->display,
            'validation' => $this->validation,
        ];
    }
}
