<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class AttributeGroupResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->inclusive('name', $this->name),
            'id' => $this->id,
            'sort_order' => $this->inclusive('sort_order', $this->sort_order),
            'num_attributes' => $this->inclusive('num_attributes', $this->attributes_count),
            'num_categories' => $this->inclusive('num_categories', $this->categories_to_attribute_groups_count),
            'num_products' => $this->inclusive('num_products', $this->products_count),
            'created_at' => $this->inclusive('created_at', $this->created_at),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'archived_at' => $this->inclusive('archived_at', $this->archived_at),
            'attributes' => $this->inclusive('attributes', $this->whenLoaded('attributes', function () {
                return AttributeInAttributeGroupResource::collection($this->attributes->sortBy('sort_order'));
            })),
        ];
    }
}
