<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use Illuminate\Http\Request;

class AttributeGroupDetailsResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->inclusive('name', $this->name),
            'sort_order' => $this->inclusive('sort_order', $this->sort_order),

            // products
            $this->mergeWhen($this->whenLoaded('products', true, false), function () {
                return [
                    'products_count_directly' => $this->inclusive('products_count_directly', $this->products->count()),
                    'products_ids_directly' => $this->inclusive('products_ids_directly', $this->products->pluck('id')),
                ];
            }),
            'products_count_directly' => $this->inclusive('products_count_directly', $this->when(isset($this->products_count), $this->products_count)),

            // products through categories
            $this->mergeWhen($this->whenLoaded('productsIdsThroughCategories', true, false), function () {
                return [
                    'products_count_through_categories' => $this->inclusive('products_count_through_categories', $this->productsIdsThroughCategories->count()),
                    'products_ids_through_categories' => $this->inclusive('products_ids_through_categories', $this->productsIdsThroughCategories->pluck('product_id')),
                ];
            }),

            // sub attribute groups
            'sub_attribute_groups_count' => $this->inclusive('sub_attribute_groups_count', $this->when(isset($this->sub_attribute_groups_count), $this->sub_attribute_groups_count)),

            // attributes
            $this->mergeWhen($this->whenLoaded('attributes', true, false), function () {
                return [
                    'attributes_count' => $this->resource->attributes->count(),
                    'attributes' => $this->inclusive('attributes', AttributeInAttributeGroupResource::collection($this->resource->attributes)),
                ];
            }),

            // categories
            $this->mergeWhen($this->whenLoaded('categories', true, false), function () {
                return [
                    'categories_count' => $this->categories->count(),
                    'categories' => $this->inclusive(
                        'categories',
                        $this->categories->map(function ($category) {
                            return $category->only('id', 'name');
                        })
                    ),
                ];
            }),
            'categories_count' => $this->inclusive('categories_count', $this->when(isset($this->categories_count), $this->categories_count)),
        ];
    }
}
