<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\AccountingTransaction;
use Illuminate\Http\Request;

/**
 * @mixin AccountingTransaction
 */
class AccountingTransactionResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'transaction_date' => $this->inclusive('transaction_date', $this->transaction_date),
            'type' => $this->inclusive('type', [
                'name' => $this->type,
                'link_type' => $this->link_type,
                'link_id' => $this->link_id,
            ]),
            'name' => $this->inclusive('name', $this->name),
            'is_tax_included' => $this->inclusive('is_tax_included', $this->is_tax_included),
            'total' => $this->inclusive('total', $this->total),
            'reference' => $this->inclusive('reference', $this->reference),
            'parent_type' => $this->inclusive('parent_type', $this->whenLoaded('parent', function () {
                return [
                    'id' => $this->parent?->id,
                    'reference' => $this->parent?->reference,
                    'name' => $this->parent?->type,
                    'link_type' => $this->parent?->link_type,
                    'link_id' => $this->parent?->link_id,
                ];
            })),
            'children' => $this->inclusive('children', $this->whenLoaded('children', function () {
                return self::collection($this->children);
            })),
            'last_synced_at' => $this->inclusive('last_synced_at', $this->whenLoaded('accountingIntegration', function () {
                return $this->accountingIntegration->getLastSyncedAt();
            })),
            'link' => $this->inclusive('last_synced_at', $this->whenLoaded('accountingIntegration', function () {
                return $this->accountingIntegration->getLink();
            })),
            'last_sync_error' => $this->inclusive('last_sync_error', $this->last_sync_error ?: null),
            'is_sync_enabled' => $this->inclusive('is_sync_enabled', $this->is_sync_enabled),
            'lines' => $this->whenLoaded('accountingTransactionLines', function () {
                return AccountingTransactionLineResource::collection($this->accountingTransactionLines);
            }),
            'status' => $this->status,
            'is_locked' => $this->is_locked,
            'is_batchable' => $this->inclusive('is_batchable', $this->is_batchable),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'created_at' => $this->inclusive('created_at', $this->created_at),
        ];
    }
}
