<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\AccountingTransactionLine;
use Illuminate\Http\Request;

/**
 * @mixin AccountingTransactionLine
 */
class AccountingTransactionLineResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'type' => $this->inclusive('type', $this->type),
            'nominal_code' => $this->whenLoaded('nominalCode', function () {
                $nominalCode = $this->nominalCode;

                return [
                    'id' => $nominalCode->id,
                    'code' => $nominalCode->code,
                    'name' => $nominalCode->name,
                ];
            }),
            'description' => $this->inclusive('description', $this->description),
            'quantity' => $this->quantity,
            'amount' => $this->amount,
            'subtotal' => $this->amount * $this->quantity,
            'tax_amount' => $this->inclusive('tax_amount', $this->tax_amount),
            'tax' => $this->inclusive('tax', $this->whenLoaded('taxRate', function () {
                $taxRate = $this->taxRate;

                return [
                    'id' => $taxRate->id,
                    'name' => $taxRate->name,
                    'rate' => $taxRate->rate,
                ];
            })),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'created_at' => $this->inclusive('created_at', $this->created_at),
        ];
    }
}
