<?php

namespace App\Http\Resources;

use App\DataTable\DataTableResource;
use App\Models\Payment;
use App\Models\PurchaseInvoice;
use App\Models\PurchaseOrder;
use Illuminate\Http\Request;

/**
 * @mixin Payment
 */
class AccountingPaymentResource extends DataTableResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'payment_date' => $this->inclusive('payment_date', $this->payment_date),
            'type' => $this->inclusive('type', [
                'name' => $this->link->accountingTransaction?->type ?? '',
                'link_type' => $this->link_type,
                'link_id' => $this->link_id,
            ]),
            'parent_reference' => $this->inclusive('parent_reference', $this->link->accountingTransaction?->reference ?? ''),
            'root' => $this->inclusive('parent_reference', function () {
                if ($this->link_type == PurchaseInvoice::class) {
                    return [
                        'root_id' => $this->link->purchaseOrder->id,
                        'root_type' => PurchaseOrder::class,
                    ];
                }

                return null;
            }),
            'amount' => $this->inclusive('amount', $this->amount),
            'external_reference' => $this->inclusive('external_reference', $this->external_reference),
            'last_synced_at' => $this->inclusive('last_synced_at', $this->whenLoaded('accountingIntegration', function () {
                return $this->accountingIntegration->getLastSyncedAt();
            })),
            'last_error' => $this->inclusive('last_error', $this->whenLoaded('accountingIntegration', function () {
                return $this->accountingIntegration->getLastError();
            })),
            'link' => $this->whenLoaded('accountingIntegration', function () {
                return $this->accountingIntegration->getLink();
            }),
            'updated_at' => $this->inclusive('updated_at', $this->updated_at),
            'created_at' => $this->inclusive('created_at', $this->created_at),
        ];
    }
}
