<?php

namespace App\Http\Requests;

use App\Models\Warehouse;
use App\Validator;
use Illuminate\Foundation\Http\FormRequest;

class StoreWarehousePrioritySetting extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'priority' => 'required|array',
            'priority.*' => 'required',
        ];
    }

    public function withValidator(Validator $validator)
    {
        if ($validator->passes()) {
            $validator->after(function (Validator $validator) {
                $attributes = $validator->attributes();
                $nonSupplierWarehouseIds = array_unique(array_filter($attributes['priority'], function ($warehouseId) {
                    return $warehouseId > 0;
                }));

                $total = Warehouse::with([])->whereIn('id', $nonSupplierWarehouseIds)->count();

                if ($total !== count($nonSupplierWarehouseIds)) {
                    $validator->addFailure('priority', 'MustBeValidWarehouses');
                }
            });
        }
    }

    public function messages(): array
    {
        return [
            'must_be_valid_warehouses' => 'Warehouse priority must be valid warehouse ids.',
        ];
    }
}
