<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreShippingCarrier extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'name' => 'required|max:255|unique:shipping_carriers,name,'.$this->route('shipping_carrier'),
            'tracking_link' => 'nullable|max:255',
            'shipping_methods' => 'nullable|array',
            'shipping_methods.*.name' => 'required|max:255',
            'shipping_methods.*.delivery_min' => 'nullable|integer',
            'shipping_methods.*.delivery_max' => 'nullable|integer',
            'shipping_methods.*.included_locations' => 'nullable|array',
            'shipping_methods.*.excluded_locations' => 'nullable|array',
        ];

        if ($this->getMethod() == 'PUT') {
            $rules['name'] = 'sometimes|'.$rules['name'];
            $rules['shipping_methods.*.name'] = 'sometimes|'.$rules['shipping_methods.*.name'];
            $rules['shipping_methods.*.id'] = 'nullable|exists:shipping_methods,id';
        }

        return $rules;
    }
}
