<?php

namespace App\Http\Requests;

use App\Models\SalesChannelType;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class StoreSalesChannel.
 */
class StoreSalesChannel extends FormRequest
{
    use BindsRequiredRules;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $oauth_channel_types = [
            SalesChannelType::TYPE_EBAY,
            SalesChannelType::TYPE_SHOPIFY,
            SalesChannelType::TYPE_Google_Express,
            SalesChannelType::TYPE_Magento,
        ];
        foreach ($oauth_channel_types as $oauthChannelType) {
            $oauthSalesChannelTypeIds[] = SalesChannelType::SALES_CHANNEL_TYPES[$oauthChannelType]['id'];
        }

        $rules = [
            'state' => 'required_if:type_id,'.implode(',', $oauthSalesChannelTypeIds),
            'name' => 'unique:sales_channels,name,'.$this->route()->originalParameter('sales_channel'),
            'type_id' => 'exists:sales_channel_types,id',
            'credentials' => 'required_unless:type_id,'.implode(',', $oauthSalesChannelTypeIds).'|array',
            'options' => 'nullable|array',
            'store_id' => 'nullable|exists:stores,id',
        ];

        if (auth('basic')->check()) {
            unset($rules['state'] , $rules['credentials']);
        }

        if ($this->getMethod() === 'POST') {
            $rules = $this->bindRequiredRules($rules);
        }

        return $rules;
    }

    public function requiredOnStore(): array
    {
        return ['name', 'type_id'];
    }
}
