<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreReceivedGoods extends FormRequest
{
    use BindsRequiredRules;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'received_date' => 'date',
            'purchase_order_id' => 'numeric|min:1',
            'products' => 'array|min:1',
            'products.*.product_id' => 'required|exists:products,id',
            'products.*.quantity' => 'required|numeric|min:1',
            'products.*.warehouse_id' => 'required|exists:warehouses,id',
            'products.*.warehouse_location_id' => 'required|exists:warehouse_locations,id',
        ];

        if ($this->getMethod() === 'POST') {
            $rules = $this->bindRequiredRules($rules);
        }

        return $rules;
    }

    public function requiredOnStore()
    {
        return ['received_date', 'purchase_order_id', 'products'];
    }
}
