<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreReceiptWarehouseTransfer extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'receipts' => 'required|array|min:1',
            'receipts.*.receipt_date' => 'required|date',
            'receipts.*.warehouse_transfer_id' => 'required|exists:warehouse_transfers,id',
            'receipts.*.to_warehouse_location_id' => 'required|exists:warehouse_locations,id',
            'receipts.*.quantity' => 'required|numeric|min:1',
            'receipts.*.discard_quantity' => 'nullable|numeric',
            'receipts.*.blemished_quantity' => 'nullable|numeric',
            'receipts.*.damage_notes' => 'required_with:receipts.*.discard_quantity,receipts.*.blemished_quantity|max:255',
            'receipts.*.blemished_sku' => 'required_with:receipts.*.blemished_quantity|unique:products,sku|max:255',
            'receipts.*.blemished_condition' => 'required_with:receipts.*.blemished_quantity|max:255',
            'receipts.*.blemished_notes' => 'required_with:receipts.*.blemished_quantity|max:255',
        ];
    }
}
