<?php

namespace App\Http\Requests;

use App\Models\PurchaseOrder;
use App\Services\PurchaseOrder\PurchaseOrderValidator;
use App\Validator;
use Illuminate\Foundation\Http\FormRequest;

class StorePurchaseOrder extends FormRequest
{
    use InstanceFromCustom, LockRequestTrait;

    const APPROVAL_STATUS_PENDING = 'pending';

    const APPROVAL_STATUS_APPROVED = 'approved';

    const APPROVAL_STATUS = [self::APPROVAL_STATUS_PENDING, self::APPROVAL_STATUS_APPROVED];

    /**
     * @var PurchaseOrderValidator
     */
    private $engine;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    private function getEngine(): PurchaseOrderValidator
    {
        if (! $this->engine) {
            /** @var PurchaseOrder $order */
            $order = $this->route('purchase_order'); // For updates

            $this->engine = ( new PurchaseOrderValidator )->withAction(
                $this->isMethod('POST') ? PurchaseOrderValidator::PURCHASE_ORDER_ACTION_CREATE
                  : PurchaseOrderValidator::PURCHASE_ORDER_ACTION_UPDATE,
                $order
            );
        }

        return $this->engine;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return $this->getEngine()->rules();
    }

    /**
     * Configure the validator instance.
     */
    public function withValidator(Validator $validator): void
    {
        if ($validator->passes()) {
            $validator->after(function (Validator $validator) {
                return $this->getEngine()->withValidator($validator);
            });
        }
    }

    public function messages(): array
    {
        return $this->getEngine()->messages();
    }

    protected function lockId(): string
    {
        return $this->isMethod('POST') ? 'new' : ($this->route('purchase_order')->id ?: 'new');
    }
}
