<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreProductPricingTier extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'name' => 'required|max:255|unique:product_pricing_tiers,name,'.$this->route()->originalParameter('product_pricing_tier'),
            'currency_code' => 'required|exists:currencies,code',
        ];

        if ($this->isMethod('put')) {
            unset($rules['currency_code']);
            $rules['name'] = 'sometimes|'.$rules['name'];
        }

        return $rules;
    }
}
