<?php

namespace App\Http\Requests;

use App\Models\NominalCode;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class StoreNominalCode.
 */
class StoreNominalCode extends FormRequest
{
    use BindsRequiredRules;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'code' => 'string|unique:nominal_codes,code,'.$this->route('nominal_code'),
            'type' => 'in:'.implode(',', NominalCode::TYPES),
            'name' => 'max:255',
        ];

        if ($this->getMethod() === 'POST') {
            $rules = $this->bindRequiredRules($rules);
        }

        return $rules;
    }

    public function requiredOnStore(): array
    {
        return ['code', 'type', 'name'];
    }
}
