<?php

namespace App\Http\Requests;

use App\Models\StoreEmailTemplate as StoreEmailTemplateModel;
use Illuminate\Foundation\Http\FormRequest;

class StoreEmailTemplate extends FormRequest
{
    use BindsRequiredRules;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'store_id' => 'exists:stores,id',
            'type' => 'max:255',
            'subject' => 'max:255',
            'html_body' => '',
            'enabled' => 'boolean',
            'attach_pdf' => 'boolean',
            'sent_type' => 'in:'.implode(',', StoreEmailTemplateModel::SENT_TYPES),
        ];

        if ($this->getMethod() === 'POST') {
            $rules = $this->bindRequiredRules($rules);
        }

        return $rules;
    }

    public function requiredOnStore()
    {
        return [
            'store_id',
            'type',
            'subject',
            'html_body'
        ];
    }
}
