<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreCurrency extends FormRequest
{
    use BindsRequiredRules;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'code' => 'unique:currencies,code,'.$this->route('currency'),
            'conversion' => 'numeric|gt:0|lt:1000000',
            'is_default' => 'nullable|boolean',
        ];

        if ($this->getMethod() === 'POST') {
            $rules = $this->bindRequiredRules($rules);
        }

        return $rules;
    }

    public function requiredOnStore()
    {
        return ['code', 'conversion'];
    }
}
