<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreCategory extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'parent_id' => [
                'nullable',
                Rule::exists('product_categories', 'id'),
                Rule::notIn($this->route('category')),
            ],
            'name' => [
                'max:255',
                Rule::unique('product_categories', 'name')
                    ->where('parent_id', $this->input('parent_id', 'NULL') ?: 'NULL')
                    ->ignore($this->route('category')),
            ],
            'attribute_groups' => 'nullable|array',
            'attribute_groups.*' => 'required|exists:attribute_groups,id',
            'attributes' => 'nullable|array',
            'attributes.*' => 'required|exists:attributes,id',
        ];

        if ($this->getMethod() === 'POST') {
            $rules['name'] = array_merge(['required'], $rules['name']);
        }

        return $rules;
    }

    public function messages(): array
    {
        return [
            'name.unique' => __('messages.category.name_unique'),
        ];
    }
}
