<?php

namespace App\Http\Requests;

use App\Models\Attribute;
use Illuminate\Foundation\Http\FormRequest;

class StoreAttribute extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'name' => 'required|max:255|unique:attributes,name,'.$this->route('attribute'),
            'type' => 'required|in:'.implode(',', Attribute::TYPES),
            'display_options' => 'nullable|array',
            'option_values' => 'nullable|array',
            'option_values.*.value' => 'nullable|max:255',
            'option_values.*.sort_order' => 'nullable|integer',
            'validation' => 'nullable|array',
            'available_for_templates' => 'sometimes|bool',
            'attribute_group_id' => 'nullable|exists:attribute_groups,id',
            'notes' => 'nullable|max:255',
        ];

        if ($this->isMethod('PUT')) {
            $rules['name'] = 'sometimes|'.$rules['name'];
            $rules['type'] = 'sometimes|'.$rules['type'];
        }

        return $rules;
    }
}
