<?php

namespace App\Http\Requests;

use App\Models\Warehouse;
use App\Validator;
use Illuminate\Foundation\Http\FormRequest;

class SetInitialInventoryCountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'inventory_date' => 'required|date',
            'quantity' => 'required|numeric|min:1',
            'unit_cost' => 'required|numeric|min:0',
            'product_id' => 'required|exists:products,id',
            'warehouse_id' => 'required|exists:warehouses,id',
            'warehouse_location_id' => 'nullable|exists:warehouse_locations,id',
        ];
    }

    /**
     * Configure the validator instance.
     */
    public function withValidator(Validator $validator): void
    {
        if ($validator->passes()) {
            $validator->after(function (Validator $validator) {
                $attributes = $validator->attributes();

                if (empty($attributes['warehouse_location_id'])) {
                    $warehouse = Warehouse::with(['defaultLocation'])->findOrFail($attributes['warehouse_id']);
                    if (empty($warehouse->defaultLocation)) {
                        $validator->addFailure('warehouse_id', 'NeedsDefaultLocation');
                    }
                }
            });
        }
    }

    public function messages(): array
    {
        return [
            'needs_default_location' => __('messages.warehouse.warehouse_needs_location'),
        ];
    }
}
