<?php

namespace App\Http\Requests;

use App\Models\SalesOrder;
use App\Services\SalesOrder\SalesOrderValidator;
use App\Validator;
use Illuminate\Foundation\Http\FormRequest;

class SalesOrderRequest extends FormRequest
{
    use InstanceFromCustom;

    /**
     * @var SalesOrderValidator
     */
    private $engine;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    private function getEngine(): SalesOrderValidator
    {
        if (! $this->engine) {
            /** @var SalesOrder $order */
            $order = $this->route('sales_order'); // For updates

            $this->engine = ( new SalesOrderValidator() )->withAction(
                $this->isMethod('POST') ? SalesOrderValidator::SALES_ORDER_ACTION_CREATE
                  : SalesOrderValidator::SALES_ORDER_ACTION_UPDATE,
                $order
            );
        }

        return $this->engine;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return $this->getEngine()->rules();
    }

    /**
     * Configure the validator instance.
     */
    public function withValidator(Validator $validator): void
    {
        if ($validator->passes()) {
            $validator->after(function (Validator $validator) {
                return $this->getEngine()->withValidator($validator);
            });
        }
    }

    public function messages(): array
    {
        return $this->getEngine()->messages();
    }
}
