<?php

namespace App\Http\Requests;

use App\Services\SalesOrder\LineReservationAction;
use Illuminate\Foundation\Http\FormRequest;

class SalesOrderLineReservationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules(): array
    {
        return [
            'sales_order_id' => 'required|exists:sales_orders,id',
            'sales_order_lines' => 'required|array',
            'sales_order_lines.*.id' => 'required_with:sales_order_lines|exists:sales_order_lines,id',
            'sales_order_lines.*.quantity' => 'required_with:sales_order_lines|numeric|gt:0|lt:100000',
            'sales_order_lines.*.action' => 'required_with:sales_order_lines|string|in:'.collect(LineReservationAction::cases())->pluck('value')->implode(','),
        ];
    }
}
