<?php

namespace App\Http\Requests;

use App\Rules\ValidLinkTypeRule;
use Illuminate\Foundation\Http\FormRequest;

class NoteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'link_type' => ['required', new ValidLinkTypeRule()],
            'link_id' => 'required'
        ];
    }
}
