<?php

namespace App\Http\Requests;

use App\Helpers;
use App\Models\InventoryMovement;
use App\Models\Setting;
use App\Validator;
use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class InventoryStartDateRequest.
 */
class InventoryStartDateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'date' => 'required|date',
        ];
    }

    public function withValidator(Validator $validator)
    {
        if ($validator->passes()) {
            $validator->after(function (Validator $validator) {
                $date = Carbon::parse(Helpers::setting(Setting::KEY_INVENTORY_START_DATE));

                // Date must not be after any existing inventory movements
                $movementsBeforeDate = InventoryMovement::with([])->where('inventory_movement_date', '<', $date)->count();

                if ($movementsBeforeDate > 0) {
                    $validator->addFailure('date', 'MustNotBeAfterInventoryMovements');
                }
            });
        }
    }

    public function messages(): array
    {
        return [
            'must_not_be_after_inventory_movements' => 'Date must not be after any existing inventory movements.',
        ];
    }
}
