<?php

namespace App\Http\Requests;

use Illuminate\Routing\Route;

trait InstanceFromCustom
{
    public static function createFromCustom(array $inputs, string $method = 'POST', ?array $routeParameters = null): static
    {
        $instance = new static($inputs);
        $instance->setContainer(app());
        $instance->setRedirector(app('redirect'));
        $instance->method = $method;

        $instance->setRouteResolver(function () use ($routeParameters) {
            $route = new Route(null, null, null);

            $route->parameters = $routeParameters;

            return $route;
        });

        $instance->validateResolved();

        return $instance;
    }

    public function getValidator()
    {
        return $this->validator;
    }

    /**
     * Determine if the data fails the validation rules.
     */
    public function fails(): bool
    {
        return $this->validator->fails();
    }

    public function errors(): array
    {
        return $this->validator->errors()->messages();
    }
}
