<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ImportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'original_name' => 'required',
            'stored_name' => 'required',
            'mapping' => 'array',
            'mapping.*.file_field' => 'required',
            'mapping.*.expected_field' => 'required',
            'escape' => 'nullable',
            'separator' => 'nullable',
            'meta' => 'array',
            'task_id' => 'nullable',
        ];
    }
}
