<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class DropshipSalesOrderRequest extends FormRequest
{
    use InstanceFromCustom;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'warehouse_id' => ['required', Rule::exists('warehouses', 'id')->whereNotNull('supplier_id')],
            'supplier_notes' => 'nullable',
            'internal_notes' => 'nullable',
            'shipping_method_id' => 'nullable|exists:shipping_methods,id',
            'requested_shipping_method_id' => 'nullable|exists:shipping_methods,id',
            'requested_shipping_method' => 'nullable|max:255',

            // lines

            'sales_order_lines' => 'required|array|min:1',
            'sales_order_lines.*.id' => 'required|exists:sales_order_lines,id',
        ];
    }
}
