<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ConvertExternalFulfillmentsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules(): array
    {
        return [
            'fulfilled_at' => 'required|date',
            'warehouse_id' => 'required|exists:warehouses,id',
            'sales_order_id' => 'required|exists:sales_orders,id',
            'sales_order_lines' => 'required|array',
            'sales_order_lines.*.id' => 'required_with:sales_order_lines|exists:sales_order_lines,id',
            'sales_order_lines.*.quantity' => 'required_with:sales_order_lines|numeric|gt:0|lt:100000',
        ];
    }
}
