<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BulkUpdateCurrencies extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'currencies' => 'required|array|min:1',
            'currencies.*.id' => 'required|exists:currencies,id',
            'currencies.*.conversion' => 'required|numeric|min:0|lt:1000000',
            'currencies.*.is_default' => 'nullable|boolean',
        ];
    }
}
