<?php
/**
 * Created by PhpStorm.
 * User: brightantwiboasiako
 * Date: 6/9/20
 * Time: 11:39 PM.
 */

namespace App\Http\Requests;

/**
 * Trait BindsRequiredRules.
 */
trait BindsRequiredRules
{
    public function requiredOnStore(): array
    {
        return [];
    }

    /**
     * @return mixed
     */
    public function bindRequiredRules($rules)
    {
        $required = $this->requiredOnStore();
        foreach ($required as $requiredField) {
            if (isset($rules[$requiredField])) {
                $rules[$requiredField] = 'required|'.$rules[$requiredField];
            }
        }

        return $rules;
    }
}
