<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class WebhookAuthenticate
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $source = $request->segment(3);
        $sourceToken = config("webhooks.{$source}");

        if ($sourceToken && $request->input('token') !== $sourceToken) {
            abort(Response::HTTP_NOT_FOUND, 'Not found.');
        }

        return $next($request);
    }
}
