<?php

namespace App\Http\Middleware;

use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken as Middleware;

class VerifyCsrfToken extends Middleware
{
    /**
     * Indicates whether the XSRF-TOKEN cookie should be set on the response.
     *
     * @var bool
     */
    protected $addHttpCookie = true;

    /**
     * The URIs that should be excluded from CSRF verification.
     *
     * @var array
     */
    protected $except = [
        '/api/auth/login',
        '/password/email',
        '/password/reset',
        /*
         * TODO: This is the fix for CSRF on local.  Not sure if it is needed for other environments or if there is
         *  a better way to handle it
         */
        '/ebay/compliance/marketplace-account-deletion',
        '*/callback',
    ];
}
