<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckEmptyWebhookRequestMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        if (empty($request->all())) {
            return response()->json(['status' => 'error', 'message' => 'Request data is empty'], 400);
        }

        return $next($request);
    }
}
